/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 13.21)
 *
 *  Copyright Steve Summit, 1995
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 */

#include <stdlib.h>

#ifdef crudversion


double drand48()
{
	return rand() / (RAND_MAX + 1.);
}

#else

#define PRECISION 2.82e14	/* 2**48, zaokrglone w gr */

double drand48()
{
	double x = 0;
	double denom = RAND_MAX + 1.;
	double need;

	for(need = PRECISION; need > 1;
			need /= (RAND_MAX + 1.)) {
		x += rand() / denom;
		denom *= RAND_MAX + 1.;
	}

	return x;
}

#endif
